<?php
require_once __DIR__ . "/config.php";

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405);
  exit("Method not allowed");
}

$title = trim((string)($_POST['title'] ?? ''));
$lyrics = trim((string)($_POST['lyrics'] ?? ''));
$style = trim((string)($_POST['style'] ?? 'pop'));
$tempo = (int)($_POST['tempo'] ?? 120);

if ($title === '' || $lyrics === '') {
  http_response_code(400);
  exit("Missing title or lyrics.");
}
if ($tempo < 60 || $tempo > 180) $tempo = 120;

// Create job in DB
$stmt = $pdo->prepare("INSERT INTO song_jobs (user_id, title, lyrics, style, tempo, status, progress) VALUES (NULL, ?, ?, ?, ?, 'queued', 0)");
$stmt->execute([$title, $lyrics, $style, $tempo]);
$jobId = (int)$pdo->lastInsertId();

// Call AI API to start generation
$payload = json_encode([
  "job_id" => $jobId,
  "title" => $title,
  "lyrics" => $lyrics,
  "style" => $style,
  "tempo" => $tempo,
  "callback_url" => (isset($_SERVER['HTTPS']) ? "https://" : "http://") . $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['REQUEST_URI']), "/") . "/webhook.php"
], JSON_UNESCAPED_UNICODE);

$ch = curl_init($AI_API_BASE . "/jobs");
curl_setopt_array($ch, [
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POST => true,
  CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
  CURLOPT_POSTFIELDS => $payload,
  CURLOPT_TIMEOUT => 30,
]);

$response = curl_exec($ch);
$httpCode = (int)curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curlErr = curl_error($ch);
curl_close($ch);

if ($response === false || $httpCode < 200 || $httpCode >= 300) {
  $pdo->prepare("UPDATE song_jobs SET status='failed', error_message=?, progress=0 WHERE id=?")
      ->execute(["AI API error: " . ($curlErr ?: "HTTP $httpCode"), $jobId]);
  header("Location: status.php?error=ai");
  exit;
}

header("Location: result.php?id=" . $jobId);
exit;
