<?php
require_once __DIR__ . "/config.php";
?>
<!doctype html>
<html lang="de">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>SongAI – Text zu Song</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
  <div class="row justify-content-center">
    <div class="col-lg-9">
      <div class="card shadow-sm border-0">
        <div class="card-body p-4">
          <h3 class="mb-2">🎵 SongAI Generator</h3>
          <p class="text-muted mb-4">Schreibe den Text, wähle Stil und generiere einen Song.</p>

          <form method="post" action="submit.php" class="row g-3">
            <div class="col-md-6">
              <label class="form-label">Titel</label>
              <input type="text" name="title" class="form-control" required maxlength="190" placeholder="z.B. Mein Song">
            </div>

            <div class="col-md-3">
              <label class="form-label">Stil</label>
              <select name="style" class="form-select">
                <option value="pop">Pop</option>
                <option value="rap">Rap</option>
                <option value="rock">Rock</option>
                <option value="folk">Folk</option>
                <option value="edm">EDM</option>
              </select>
            </div>

            <div class="col-md-3">
              <label class="form-label">Tempo (BPM)</label>
              <input type="number" name="tempo" class="form-control" min="60" max="180" value="120">
            </div>

            <div class="col-12">
              <label class="form-label">Lyrics / Text</label>
              <textarea name="lyrics" class="form-control" rows="10" required maxlength="4000"
                placeholder="Shkruaje tekstin e këngës këtu..."></textarea>
              <div class="form-text">Max 4000 karaktere.</div>
            </div>

            <div class="col-12 d-flex gap-2">
              <button class="btn btn-primary px-4">Generate Song</button>
              <a class="btn btn-outline-secondary" href="status.php">Meine Jobs</a>
            </div>
          </form>

        </div>
      </div>

      <div class="text-center text-muted small mt-3">
        Web läuft auf PHP + MySQL • Generierung läuft via AI API
      </div>
    </div>
  </div>
</div>
</body>
</html>
