<?php
declare(strict_types=1);

// ====== DATABASE CONFIG (EDIT) ======
$dbHost = "localhost";
$dbName = "YOUR_DB_NAME";
$dbUser = "YOUR_DB_USER";
$dbPass = "YOUR_DB_PASS";

// ====== AI SERVER BASE URL (EDIT) ======
$AI_API_BASE = "https://YOUR-AI-SERVER-DOMAIN";

// ====== PDO SETUP ======
$options = [
  PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
  PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
  PDO::ATTR_EMULATE_PREPARES => false,
];

try {
  $pdo = new PDO("mysql:host={$dbHost};dbname={$dbName};charset=utf8mb4", $dbUser, $dbPass, $options);
} catch (Throwable $e) {
  http_response_code(500);
  echo "DB connection failed.";
  exit;
}

function h(string $s): string { return htmlspecialchars($s, ENT_QUOTES, 'UTF-8'); }
